/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.updates;

import com.ibm.hwmca.base.updates.BaseUpdateStyle;
import com.ibm.hwmca.base.updates.BaseUpdater;
import com.ibm.hwmca.base.updates.ECFilter;
import com.ibm.hwmca.base.updates.ECStream;
import com.ibm.hwmca.base.updates.MCLErrorIds;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.updates.UpdateStyle;
import com.ibm.hwmca.xfw.updates.Updater;
import com.ibm.hwmca.xfw.updates.UpdatesOwner;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class BaseUpdatesOwner
implements UpdatesOwner,
MCLErrorIds {
    private static final String TRACE_MASKT = "XMCLOWNT";
    private static final String TRACE_MASKF = "XMCLOWNF";
    private static final String TRACE_MASKD = "XMCLOWND";
    protected static final String EC_OS_FILES = "H25117.ECC";
    protected static final String EC_CODE_FILES = "H25117.ECD";
    private static final FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(2, "XMCL");
    private List updateableComponents;

    public BaseUpdatesOwner() {
        Trace.trace(TRACE_MASKT, "-> BaseUpdatesOwner()");
        this.updateableComponents = new ArrayList();
        try {
            ECStream nextECstream;
            int i;
            File ecOSPath = new File(BaseFileControl.getFilePath(EC_OS_FILES));
            File ecCodePath = new File(BaseFileControl.getFilePath(EC_CODE_FILES));
            Trace.trace(TRACE_MASKF, "ecOSPath=[" + ecOSPath + "] ecCodePath=[" + ecCodePath + "].");
            String[] files = ecOSPath.list(new ECFilter("ECC"));
            for (i = 0; i < files.length; ++i) {
                Trace.trace(TRACE_MASKF, "The file " + files[i] + " represents an EC");
                try {
                    nextECstream = new ECStream(this, files[i]);
                    this.updateableComponents.add(nextECstream);
                    continue;
                }
                catch (HException hexc) {
                    Trace.trace(TRACE_MASKF, "Could not construct an EC stream from file " + files[i] + ".");
                }
            }
            files = ecCodePath.list(new ECFilter("ECD"));
            for (i = 0; i < files.length; ++i) {
                Trace.trace(TRACE_MASKF, "The file " + files[i] + " represents an EC");
                try {
                    nextECstream = new ECStream(this, files[i]);
                    this.updateableComponents.add(nextECstream);
                    continue;
                }
                catch (HException hexc) {
                    Trace.trace(TRACE_MASKF, "Could not construct an EC stream from file " + files[i] + ".");
                }
            }
        }
        catch (HException hexc) {
            this.logError("Unable to find where ECC or ECD files go", (short)-4096, hexc);
        }
        Trace.trace(TRACE_MASKT, "<- BaseUpdatesOwner()");
    }

    public List getUpdateableComponents() {
        Trace.trace(TRACE_MASKT, "<> getUpdateableComponents returns " + this.updateableComponents.size() + " components.");
        return this.updateableComponents;
    }

    public Updater getUpdaterInstance() {
        return new BaseUpdater(this);
    }

    public UpdateStyle getUpdateStyle() {
        return new BaseUpdateStyle();
    }

    private void logError(String errorString, short errorId, HException hexc) {
        Trace.trace(TRACE_MASKD, "-> logError()");
        Trace.trace(TRACE_MASKF, errorString);
        new FrameworkLog(logInfo, errorId, hexc).log();
    }
}

